/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* -----------------------------------------------------------------------
 * File: ladata.h
 * Author: Tilmann Wendel 4.6.96
 * Purpose: This file contains the function prototypes for the logic 
 * analyzer control functions. Read and set Trigger functions are also
 * provided here.
 * ----------------------------------------------------------------------- */

/* -----------------------------------------------------------------------
 * Performance Board function prototypes  added:    
 * Robert Siegmund, 10.03.97 BID R&D
 *------------------------------------------------------------------------ */
 

#ifndef LADATA_H_INCLUDED
#define LADATA_H_INCLUDED

#include <ladefs.h>
#include <trcdefs.h>


#ifdef __cplusplus
extern "C" {
#endif


/* -----------------------------------------------------------------------
 * PCI Trace & External Trigger Functions
 * ----------------------------------------------------------------------- */
CLI  b_errtype EXPORT BestTracePropSet(           /* @trcprpset */ 
    b_handletype    handle,
    b_traceproptype traceprop,                    /* @prop */
    b_int32         value                         /* @val */    
    );

CLI  b_errtype EXPORT BestTracePropGet(           /* @trcprpget */ 
    b_handletype    handle,
    b_traceproptype traceprop,                    /* @prop */
    b_int32         *value                        /* #RETURN  "property value = %lu"*/
    );

CLI  b_errtype EXPORT BestTracePropDefaultSet(           /* @trcprpdefset */ 
    b_handletype    handle
    );

CLI  b_errtype EXPORT BestTracePattPropSet(       /* @trcpprpset */
    b_handletype        handle,
    b_tracepattproptype traceprop,                /* @prop */
    b_charptrtype       pattern                   /* @patt */
    );

CLI  b_errtype EXPORT BestTraceRun(               /* @trcrun */
    b_handletype handle
    );


CLI  b_errtype EXPORT BestTraceStop(              /* @trcstop */
    b_handletype handle
    );

CLI  b_errtype EXPORT BestTraceStatusGet(         /* @tsget */
    b_handletype handle,
    b_tracestatustype tracestatus,            /* @stat */
    b_int32 *status                           /*  #RETURN  "status = %08lx\\h\n"*/
    );


/* -----------------------------------------------------------------------
 * PCI Tracememory data functions
 * ----------------------------------------------------------------------- */

/* use for besttracedataget the maximum number of longs per line */
CLI  b_errtype EXPORT BestTraceDataGet(           /* @trcdget */
    b_handletype handle,
    b_int32 startline,                            /* @start  */
    b_int32 n_of_lines,                           /* @nol  */
    b_int32 HUGE * data /* #RETURN datalist(data,n_of_lines)  [n_of_lines * 5]*/
    );

CLI b_errtype EXPORT BestTraceBytePerLineGet(     /* @trcbtplget */
				  b_handletype handle,
				  b_int32 * bytes_per_line /* #RETURN "%lu\n" */
				  );

CLI b_errtype EXPORT BestTraceBitPosGet(          /* @trcbtposget */
				 b_handletype handle,
				 b_signaltype signal,  /* signal */
				 b_int32 *position,   /* #RETURN "Pos: %lu\n" */
				 b_int32 *length      /* #RETURN "Len: %lu\n" */
				 );

CLI b_errtype EXPORT BestTraceMemorySizeGet(      /* @trcmemget */
                                b_handletype handle,
				b_int32 *mode     /* #RETURN "Size: 0x%x\n" */
                                );

CLI  b_errtype EXPORT BestGapInfo(                /* @gapinfo */
    b_handletype handle,
    b_int32 num_samples,                          /* @num  */
    b_int32 HUGE * data                           /* #RETURN "%x\\h" */
    );

b_errtype EXPORT BestGapModeGet(b_handletype handle,
                                b_int32 *mode
				);

/* -----------------------------------------------------------------------
 * PCI Analyzer Functions
 * ----------------------------------------------------------------------- */

CLI b_errtype EXPORT BestAnalyzerRun(             /* @arun */
    b_handletype handle
    );


CLI b_errtype EXPORT BestAnalyzerStop(            /* @astop */
    b_handletype handle
    );

/* ---------------------------------------------------------------------------
 * Here start the performance option CAPI function prototypes.
 * ------------------------------------------------------------------------- */

CLI b_errtype EXPORT BestPattSet(                /* @pattset   */
    b_handletype handle,
    b_int32 pattern_ident,                       /* @pid         */
    b_charptrtype pattern                        /* @patt        */
    );

b_errtype BestPattGetEdit (
    b_handletype handle,
    b_int64 patt_id,
    b_ccharptrtype *pattern
    );

CLI b_errtype EXPORT BestTraceMemoryFileDump(     /* @trcdump */
    b_handletype handle,
    b_charptrtype filename                        /* @file */
    );

/* This function cannot be called from CLI (pointer to function!) */
#define B_WFM_STANDARD      0
#define B_WFM_COMPRESSED_1  1

#define B_WFM_THRESHOLD     0x3ffff

#define B_WFM_COMP_1_STRING  "COMP_1"

b_errtype EXPORT BestTraceMemoryFileDumpAdv (
    b_handletype handle,
    b_charptrtype filename,
    b_int32 pretrig,
    b_int32 posttrig,
    int (*cb) (int),
    int modebit,
    int storemode);



#ifdef __cplusplus
}
#endif

#endif

